#pragma semicolon 1

#include <sourcemod>
#include <sdktools>
#include <morecolors>
#include <tf2>
#include <tf2_stocks>
#include <loghelper>

#define PLUGIN_VERSION "1.0.0"

public Plugin:myinfo = {
  name = "DG Plugin",
  author = "aj",
  description = "DG stuff.",
  version = PLUGIN_VERSION,
};

enum PlayerFields {
  bool:Playing,
  bool:NotPlaying,
  InitialDrinks,
  RoundDrinks,
  TotalDrinks,
  Taunts,
  RoundsSinceDrink,
  RoundStartScore,
  NumMessages,
  Destroyed,
  Headshots,
  String:MessageCache[1000],
  Handle:MessageTimers[7],
  Handle:ShortTimers[10],
  ShortCount,
  Handle:LongTimers[25],
  Handle:ResetTimer,
  LongCount
}

const MaxMessages = 5;
const Float:MessageTime = 12.0;
const Float:ResetDelay = 15.0;
const Float:ShortTimeout = 120.0;
const Float:LongTimeout = 300.0;
const ShortMax = 3;
const ShortMaxHandles = 10;
const LongMaxHandles = 25;

new playerData[34][PlayerFields];
new Handle:HudMessage;
new bool:enabled;
new bool:enabledAll;
new offsetPlayerScore, entPlayerManager;
new Handle:Database;

public OnPluginStart() {
  RegConsoleCmd("sm_dg", OnDg, "fuck", FCVAR_PLUGIN);
  RegConsoleCmd("sm_fuckdg", OnFuckDg, "fuck", FCVAR_PLUGIN);
  RegAdminCmd("sm_dgall", OnEnableAll, ADMFLAG_BAN, "fuck", "fuck", FCVAR_PLUGIN);
  RegAdminCmd("sm_dgenable", OnEnable, ADMFLAG_BAN, "fuck", "fuck", FCVAR_PLUGIN);
  RegAdminCmd("sm_dgvegetable", OnVegetable, ADMFLAG_BAN, "fuck", "fuck", FCVAR_PLUGIN);
  RegAdminCmd("sm_dgmessage", OnMessage, ADMFLAG_BAN, "fuck", "fuck", FCVAR_PLUGIN);

  HookEventEx("teamplay_round_win", OnRoundWon);
  HookEventEx("player_death", OnDeath);
  HookEventEx("player_chargedeployed", OnUber);
  HookEventEx("medic_death", OnMedicDeath);
  //HookEventEx("fish_notice", OnFish);
  HookEventEx("deploy_buff_banner", OnBuff);
  //HookEventEx("player_stunned", OnStun);
  HookEventEx("object_destroyed", OnDestroyed);

  offsetPlayerScore = FindSendPropOffs("CTFPlayerResource", "m_iTotalScore");

  enabled = true;
  enabledAll = false;

  CreateTimer(0.3, ShowAllMessages, _, TIMER_REPEAT);
  CreateTimer(5.0, CheckNames, _, TIMER_REPEAT);

  HudMessage = CreateHudSynchronizer();
  LoadTranslations("common.phrases");

  SQL_TConnect(OnDatabase, "hlxce");
}

public OnMapStart() {
  entPlayerManager = FindEntityByClassname(-1, "tf_player_manager");
  for (new c = 1; c <= MaxClients; c++) {
    ResetPlayer(c);
  }
}

public OnDatabase(Handle:owner, Handle:hndl, const String:error[], any:data) {
  if (hndl == INVALID_HANDLE) LogError("Connection Error: %s", error);
  Database = hndl;
}

public Action:OnEnable(const client, args) {
  LogAction(client, 0, "sm_dgenable");
  enabled = true;
}

public Action:OnFuckDg(const client, args) {
  playerData[client][NotPlaying] = true;
}

public Action:OnEnableAll(const client, args) {
  LogAction(client, 0, "sm_dgall");
  if (args > 0) {
    new String:arg[5];
    GetCmdArgString(arg, 5);
    if (StrContains(arg, "0", false) >= 0) {
      enabledAll = false;
      return;
    }
  }

  enabled = true;
  enabledAll = true;

  for(new any:c = 1; c <= MaxClients; c++) {
    ShowAllMessage(INVALID_HANDLE, c);
  }
}

public Action:ShowAllMessage(Handle:timer, any:c) {
  if(IsClientInGame(c) && !IsFakeClient(c) && enabledAll == true) {
    AddMessage("The Drinking Game is enabled for everyone.  Type !dg for a leaderboard.", c);
    AddMessage("Taunt someone after killing them to make them drink.", c);
  }
}

public Action:OnDg(const client, args) {
  ShowDgMenu(client);
}

public Action:OnVegetable(const client, args) {
  LogAction(client, 0, "sm_dgvegetable");
  for(new c = 1; c <= MaxClients; c++) {
    if(IsClientInGame(c)) {
      if (!IsPlaying(c)) continue;
      AddDrink("You have not eaten enough VEG-E-TAB-LES.  Take a drink!", c);
    }
  }
}

public Action:OnMessage(const client, args) {
  LogAction(client, 0, "sm_dgmessage");
  new String:message[100];
  GetCmdArgString(message, 100);

  for(new c = 1; c <= MaxClients; c++) {
    if(IsClientInGame(c)) {
      if (!IsPlaying(c)) continue;
      AddDrink(message, c);
    }
  }
}

public OnClientDisconnect(client) {
  ResetPlayer(client);
}

public OnClientPostAdminCheck(client) {
  ResetPlayer(client);
  if (IsFakeClient(client)) return;
  LoadDrinks(client);
  CreateTimer(5.0, ShowAllMessage, client);
}

public OnDeath(Handle:event, const String:name[], bool:dontBroadcast) {
  if(GetEventBool(event, "feign_death")) return;
  new client = GetClientOfUserId(GetEventInt(event, "userid"));
  new attacker = GetClientOfUserId(GetEventInt(event, "attacker"));

  if(IsPlayerAlive(client)) return;

  new bool:headshot = GetEventInt(event, "customkill") == 1;
  if (IsPlaying(attacker)) {
    if (headshot) {
      playerData[attacker][Headshots]++;
      if (playerData[attacker][Headshots] % 2 == 0) {
        AddDrink("You got a headshot. Take a drink!", attacker);
      }
    }
    if (playerData[attacker][RoundsSinceDrink] >= 2) {
      AddDrink("You got a kill! Take a drink!", attacker);
    }
  }

  if (!IsPlaying(client)) return;
  playerData[client][RoundsSinceDrink]++;
  if (playerData[client][RoundsSinceDrink] >= 3) {
    AddDrink("It's been 3 deaths since you took a drink.  Take a drink!", client);
  }
}

public OnUber(Handle:event, const String:name[], bool:dontBroadcast) {
  new client = GetClientOfUserId(GetEventInt(event, "userid"));
  if (!IsPlaying(client)) return;

  AddDrink("You deployed an uber charge. Take a drink!", client);
}

public OnMedicDeath(Handle:event, const String:name[], bool:dontBroadcast) {
  new client = GetClientOfUserId(GetEventInt(event, "userid"));
  if (!IsPlaying(client)) return;

  if (GetEventBool(event, "charged")) {
    AddDrink("You dropped uber. Take a drink!", client);
  }
}

public OnFish(Handle:event, const String:name[], bool:dontBroadcast) {
  new attacker = GetClientOfUserId(GetEventInt(event, "attacker"));
  new victim = GetClientOfUserId(GetEventInt(event, "userid"));

  if(IsPlaying(attacker)) {
    AddDrink("You got a fish kill. Take a drink!", attacker);
  }

  if(IsPlaying(victim)) {
    AddDrink("You got fish killed. Take a drink!", victim);
  }
}

public OnBuff(Handle:event, const String:name[], bool:dontBroadcast) {
  new client = GetClientOfUserId(GetEventInt(event, "buff_owner"));
  if (!IsPlaying(client)) return;

  AddDrink("You deployed a buff banner. Take a drink!", client);
}

public OnStun(Handle:event, const String:name[], bool:dontBroadcast) {
  new attacker = GetClientOfUserId(GetEventInt(event, "stunner"));
  new victim = GetClientOfUserId(GetEventInt(event, "victim"));

  if(IsPlaying(attacker)) {
    AddDrink("You stunned someone. Take a drink!", attacker);
  }

  if(IsPlaying(victim)) {
    AddDrink("You got stunned. Take a drink!", victim);
  }
}

public OnDestroyed(Handle:event, const String:name[], bool:dontBroadcast) {
  new client = GetClientOfUserId(GetEventInt(event, "userid"));
  if (!IsPlaying(client)) return;
  if (GetEventInt(event, "objecttype") != 2) return;

  playerData[client][Destroyed]++;
  if (playerData[client][Destroyed] % 2 == 0) {
    AddDrink("Your sentry got fucked. Take a drink!", client);
  }
}

public OnClientStreak(client, kills) {
  if (!IsPlaying(client)) return;
  new String:message[100];
  Format(message, 100, "You played a killstreak song at %d. Take a drink!", kills);
  AddDrink(message, client);
}

public OnClientTaunt(taunter, tauntee) {
  if (!IsPlaying(tauntee)) return;
  new String:message[100];
  new String:name[32];

  playerData[tauntee][Taunts]++;
  GetClientName(taunter, name, 32);
  Format(message, 100, "You got taunted by %s.  Take a drink!", name);
  AddDrink(message, tauntee);
}

public Action:OnRoundWon(const Handle:event, const String:name[], const bool:dontBroadcast) {
  new winningTeam = GetEventInt(event, "team");
  for(new c = 1; c <= MaxClients; c++) {
    if(IsClientInGame(c)) {
      if (!IsPlaying(c)) continue;
      if (GetClientTeam(c) == winningTeam) AddDrink("Your team won.  Take a drink!", c);
      else AddDrink("Your team lost.  Take a drink!", c);
    }
  }

  ShowMvpMessages(2);
  ShowMvpMessages(3);

  for(new c = 1; c <= MaxClients; c++) {
    playerData[c][RoundDrinks] = 0;
    if(IsClientInGame(c)) {
      playerData[c][RoundStartScore] = GetClientScore(c);
    }
  }
}

public Action:CheckNames(Handle:timer) {
  decl String:name[32];
  for (new c = 1; c <= MaxClients; c++) {
    if (playerData[c][Playing]) continue;
    if (!IsClientInGame(c) || IsFakeClient(c)) continue;

    GetClientName(c, name, 32);
    if (StrContains(name, "[dg]", false) >= 0 || StrContains(name, "{dg}", false) >= 0) {
      StartPlaying(c);
    }
  }
}

public ShowMvpMessages(const team) {
  new String:message[100];
  new SortedScoreArray[MaxClients][2];
  new client = 0;
  for(new c = 0; c < MaxClients; c++) {
    SortedScoreArray[c][0] = (client = c + 1);
    if(IsClientInGame(client) && GetClientTeam(client) == team) {
      SortedScoreArray[c][1] = GetClientScore(client) - playerData[client][RoundStartScore];
    } else {
      SortedScoreArray[c][1] = -1;
    }
  }
  SortCustom2D(SortedScoreArray, MaxClients, SortScoreDesc);
  for(new c = 0; c < 3; c++) {
    if (SortedScoreArray[c][1] >= 0) {
      if (!IsPlaying(SortedScoreArray[c][0])) continue;
      Format(message, 100, "You made the MVP board.  Take a drink!");
      AddDrink(message, SortedScoreArray[c][0]);
    }
  }
}

public SortScoreDesc(x[], y[], array[][], Handle:data) {
  if (x[1] > y[1]) return -1;
  else if (x[1] < y[1]) return 1;
  return 0;
}

public GetClientScore(client) {
  if (IsClientInGame(client)) return GetEntData(entPlayerManager, offsetPlayerScore + (client * 4), 4);
  return -1;
}

public bool:IsPlaying(client) {
  return (enabledAll && !playerData[client][NotPlaying]) || playerData[client][Playing];
}

public AddDrink(String:message[], client) {
  if (playerData[client][NumMessages] >= MaxMessages) return;
  if (!IsPlaying(client)) return;

  if (playerData[client][ShortCount] > (ShortMax - 1) && GetURandomFloat() < 0.5) {
    //LogError("Ignoring drink");
    return;
  }

  ScheduleReset(client);
  playerData[client][RoundsSinceDrink] = 0;
  playerData[client][RoundDrinks]++;
  playerData[client][TotalDrinks]++;

  AddMessage(message, client);
  LogPlayerEvent(client, "triggered", "drink");

  if (playerData[client][ShortCount] < ShortMaxHandles) {
    playerData[client][ShortTimers][playerData[client][ShortCount]] = CreateTimer(ShortTimeout, OnShortTimer, client);
    playerData[client][ShortCount]++;
  }

  if (playerData[client][LongCount] < LongMaxHandles) {
    playerData[client][LongTimers][playerData[client][LongCount]] = CreateTimer(LongTimeout, OnLongTimer, client);
    playerData[client][LongCount]++;
  }
}

public RemoveDrink(client) {
  if (playerData[client][NumMessages] == 0) return;

  playerData[client][NumMessages]--;
  new count = playerData[client][NumMessages];

  for(new c = 0; c < count; c++) {
    playerData[client][MessageTimers][c] = playerData[client][MessageTimers][c+1];
  }

  new pos = FindCharInString(playerData[client][MessageCache], '\n');
  if(pos <  0) {
    strcopy(playerData[client][MessageCache], 1000, "");
  } else {
    new String:fullMessage[1000];
    strcopy(fullMessage, 1000, playerData[client][MessageCache]);
    strcopy(playerData[client][MessageCache], 1000, fullMessage[pos+1]);
  }

  ShowMessage(client);
}

public AddMessage(String:message[], client) {
  if (playerData[client][NumMessages] >= MaxMessages) return;
  decl String:fullMessage[1000];
  FormatEx(fullMessage, 1000, "%s%s\n", playerData[client][MessageCache], message);

  strcopy(playerData[client][MessageCache], 1000, fullMessage);
  playerData[client][MessageTimers][playerData[client][NumMessages]] = CreateTimer(MessageTime, RemoveMessage, client);
  playerData[client][NumMessages]++;
  ShowMessage(client);
}

public ShowMessage(client) {
  if (playerData[client][NumMessages] == 0) return;
  SetHudTextParams(0.04, 0.1, 0.3, 255, 255, 0, 255);
  ShowSyncHudText(client, HudMessage, playerData[client][MessageCache]);
}

public StartPlaying(client) {
  if (!enabledAll && !playerData[client][Playing]) {
    playerData[client][Playing] = true;

    decl String:name[40];
    GetClientName(client, name, 40);

    decl String:message[300];
    FormatEx(message, 300, "%s has started playing the drinking game. !dg to join.", name);

    decl String:message2[300];
    FormatEx(message2, 300, "Taunt after killing %s to make him drink!", name);

    for(new c = 1; c <= MaxClients; c++) {
      if(IsClientInGame(c) && !IsFakeClient(c)) {
        AddMessage(message, c);
        AddMessage(message2, c);
      }
    }
  }
}

public Action:OnShortTimer(Handle:timer, any:client) {
  if(playerData[client][ShortCount] == 0) return;

  playerData[client][ShortCount]--;
  new count = playerData[client][ShortCount];

  for(new c = 0; c < count; c++) {
    playerData[client][ShortTimers][c] = playerData[client][ShortTimers][c+1];
  }

  if(!IsPlaying(client)) return;
}

public Action:OnLongTimer(Handle:timer, any:client) {
  if(playerData[client][LongCount] == 0) return;

  playerData[client][LongCount]--;
  new count = playerData[client][LongCount];

  for(new c = 0; c < count; c++) {
    playerData[client][LongTimers][c] = playerData[client][LongTimers][c+1];
  }

  if(!IsPlaying(client)) return;
}

public ScheduleReset(player) {
  if (playerData[player][ResetTimer] != INVALID_HANDLE) {
    KillTimer(playerData[player][ResetTimer]);
  }
  playerData[player][ResetTimer] = CreateTimer(ResetDelay, DoSimpleReset, player);
}

public Action:DoSimpleReset(Handle:timer, any:player) {
  playerData[player][ResetTimer] = INVALID_HANDLE;

  strcopy(playerData[player][MessageCache], 1000, "");
  new count = playerData[player][NumMessages];
  playerData[player][NumMessages] = 0;
  for(new c = 0; c < count; c++) {
    KillTimer(playerData[player][MessageTimers][c]);
  }
}

public ResetPlayer(player) {
  playerData[player][Playing] = false;
  playerData[player][NotPlaying] = false;
  playerData[player][RoundDrinks] = 0;
  playerData[player][TotalDrinks] = 0;
  playerData[player][RoundStartScore] = 0;
  playerData[player][Taunts] = 0;
  playerData[player][RoundsSinceDrink] = 0;
  playerData[player][InitialDrinks] = 0;
  playerData[player][Destroyed] = 0;
  playerData[player][Headshots] = 0;
  strcopy(playerData[player][MessageCache], 1000, "");

  if (playerData[player][ResetTimer] != INVALID_HANDLE) {
    KillTimer(playerData[player][ResetTimer]);
    playerData[player][ResetTimer] = INVALID_HANDLE;
  }

  new count = playerData[player][NumMessages];
  playerData[player][NumMessages] = 0;
  for(new c = 0; c < count; c++) {
    KillTimer(playerData[player][MessageTimers][c]);
  }

  count = playerData[player][ShortCount];
  playerData[player][ShortCount] = 0;
  for(new c = 0; c < count; c++) {
    KillTimer(playerData[player][ShortTimers][c]);
  }

  count = playerData[player][LongCount];
  playerData[player][LongCount] = 0;
  for(new c = 0; c < count; c++) {
    KillTimer(playerData[player][LongTimers][c]);
  }
}

public Action:ShowAllMessages(Handle:timer) {
  for(new c = 1; c <= MaxClients; c++) {
    if(IsClientInGame(c)) ShowMessage(c);
  }
}

public Action:RemoveMessage(Handle:timer, any:client) {
  RemoveDrink(client);
}

public LoadDrinks(client) {
  decl String:query[350];
  decl String:auth[30];
  decl String:date[30];

  GetClientAuthString(client, auth, sizeof(auth));
  FormatTime(date, sizeof(date), "%Y-%m-%d %H:%M:00", GetTime() - 12 * 3600);
  FormatEx(query, sizeof(query), "SELECT COUNT(*) AS c FROM hlstats_playeruniqueids, hlstats_events_playeractions WHERE actionId = 653 AND hlstats_playeruniqueids.uniqueId = '%s' AND hlstats_playeruniqueids.playerId = hlstats_events_playeractions.playerId AND eventTime > '%s'", auth[8], date);

  SQL_TQuery(Database, OnLoadDrinks, query, GetClientUserId(client), DBPrio_High);
}

public OnLoadDrinks(Handle:owner, Handle:hndl, const String:error[], any:userid) {
  new client = GetClientOfUserId(userid);
  if(!client)
    return;

  /* Failure happen. Do retry with delay */
  if(hndl == INVALID_HANDLE) {
    LogError("WTF QUERY FAILED :( %s", error);
    return;
  }

  SQL_FetchRow(hndl);
  playerData[client][InitialDrinks] = SQL_FetchInt(hndl, 0);
  playerData[client][TotalDrinks] += playerData[client][InitialDrinks];
}

public Action:ShowDgMenu(client) {
  if(!enabled) return;

  new Handle:menu = CreateMenuEx(GetMenuStyleHandle(MenuStyle_Radio), OnMenuItem);
  SetMenuTitle(menu, "Taunt Drinking Game");

  if (playerData[client][Playing]) AddMenuItem(menu, "Option 1", "Disable");
  else AddMenuItem(menu, "Option 1", "Enable");

  AddMenuItem(menu, "Option 2", "Drink Board");

  new String:message[100];

  if (enabledAll || playerData[client][Playing]) Format(message, 100, "Playing: Yes");
  else  Format(message, 100, "Playing: No");
  AddMenuItem(menu, "Playing", message, ITEMDRAW_DISABLED);

  Format(message, 100, "Round Drinks %d", playerData[client][RoundDrinks]);
  AddMenuItem(menu, "Round Drinks", message, ITEMDRAW_DISABLED);

  Format(message, 100, "Total Drinks %d", playerData[client][TotalDrinks]);
  AddMenuItem(menu, "Total Drinks", message, ITEMDRAW_DISABLED);

  Format(message, 100, "Times Taunted %d", playerData[client][Taunts]);
  AddMenuItem(menu, "Times Taunted", message, ITEMDRAW_DISABLED);

  DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public OnMenuItem(Handle:menu, MenuAction:action, client, index) {
  switch (action) {
    case MenuAction_Select: {
      if(IsClientInGame(client)) {
        switch(index) {
          case 0:
            if(enabled && !enabledAll) {
              if (playerData[client][Playing]) playerData[client][Playing] = false;
              else StartPlaying(client);
            }
          case 1:
            ShowDrinkBoard(client);
        }
      }
    }

    case MenuAction_Cancel: {
    }

    case MenuAction_End: {
      CloseHandle(menu);
    }
  }
}

public ShowDrinkBoard(client) {
  new Handle:menu = CreateMenuEx(GetMenuStyleHandle(MenuStyle_Radio), OnDrinkBoard);
  SetMenuTitle(menu, "Taunt Drinking Game Leaderboard");
  SetMenuExitBackButton(menu, true);

  new String:message[100];
  new String:name[32];

  new SortedScoreArray[MaxClients][2];
  new tempClient = 0;
  for(new c = 0; c < MaxClients; c++) {
    SortedScoreArray[c][0] = (tempClient = c + 1);
    if(IsClientInGame(tempClient) && IsPlaying(tempClient)) {
      SortedScoreArray[c][1] = playerData[tempClient][TotalDrinks];
    } else {
      SortedScoreArray[c][1] = -1;
    }
  }
  SortCustom2D(SortedScoreArray, MaxClients, SortScoreDesc);

  for (new c = 0; c < MaxClients; c++) {
    if(SortedScoreArray[c][1] < 0) continue;
    tempClient = SortedScoreArray[c][0];

    GetClientName(tempClient, name, 32);
    Format(message, 100, "%s %d-%d", name, playerData[tempClient][RoundDrinks], playerData[tempClient][TotalDrinks]);
    AddMenuItem(menu, message, message, ITEMDRAW_DISABLED);
  }
  AddMenuItem(menu, "Close", "Close");

  DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public OnDrinkBoard(Handle:menu, MenuAction:action, client, index) {
  switch (action) {
    case MenuAction_Select: {
    }

    case MenuAction_Cancel: {
      ShowDgMenu(client);
    }

    case MenuAction_End: {
      CloseHandle(menu);
    }
  }
}