#pragma semicolon 1
#pragma newdecls required

#include <sourcemod>
#include <sdktools>
#include <tf2>
#include <tf2_stocks>
#include <entity>

#define PLUGIN_AUTHOR  "ack"
#define PLUGIN_VERSION "0.02"

public Plugin myinfo = {
	name = "eotl_eh",
	author = PLUGIN_AUTHOR,
	description = "Engie Hell Related Stuffs",
	version = PLUGIN_VERSION,
	url = ""
};

ConVar g_cvRoundTime;
ConVar g_cvForceTeams;
bool g_bMapHasSetup;

public void OnPluginStart() {
    LogMessage("version %s starting", PLUGIN_VERSION);

    HookEvent("teamplay_setup_finished", EventSetupFinished, EventHookMode_PostNoCopy);
    HookEvent("player_spawn", EventPlayerSpawn);

    g_cvRoundTime = CreateConVar("eotl_eh_round_time", "3600", "Round Time for Maps", FCVAR_NOTIFY);
    g_cvForceTeams = CreateConVar("eotl_eh_force_teams", "0", "0/1 force humans to blue, bots to red", FCVAR_NOTIFY);

}

public void OnMapStart() {

    int roundTimer;
    int setupTimeOffset;
    int setupTime;

    // figure out when we need to adjust the round time.  If a map has a setup
    // time, we need to do it after that.  Otherwise we adjust it after waiting
    // for players.
    g_bMapHasSetup = false;
    roundTimer = FindEntityByClassname(MaxClients + 1, "team_round_timer");
    setupTimeOffset = FindSendPropInfo("CTeamRoundTimer", "m_nSetupTimeLength");
    if (IsValidEntity(roundTimer) && setupTimeOffset > 0) {
        setupTime = GetEntData(roundTimer, setupTimeOffset);
        if(setupTime > 0) {
            LogMessage("Map has a setup time of %d seconds", setupTime);
            g_bMapHasSetup = true;
        } else {
            LogMessage("Map has no setup time");
        }
    } else {
        LogMessage("ERROR: Unable to get map setup time (%d, %d)!, assuming no setup time", roundTimer, setupTimeOffset);
    }
}

public Action EventPlayerSpawn(Handle event, const char[] name, bool dontBroadcast) {

    int client;
    TFTeam team;

    if(!g_cvForceTeams.BoolValue) {
        return Plugin_Continue;
    }

    client = GetClientOfUserId(GetEventInt(event, "userid"));
    team = TF2_GetClientTeam(client);

    if(IsFakeClient(client)) {
        if(team == TFTeam_Blue) {
            LogMessage("Bot client: %d is on blue, forcing switch to red", client);
            TF2_ChangeClientTeam(client, TFTeam_Red);
        }
    } else {
        if(team == TFTeam_Red) {
            LogMessage("Player client: %d is on red, forcing switch to blue", client);
            PrintToChat(client, "\x01[\x03eh\x01] Human players are always blue");
            TF2_ChangeClientTeam(client, TFTeam_Blue);
        }

    }
    return Plugin_Continue;
}

public void TF2_OnWaitingForPlayersEnd() {
    if(!g_bMapHasSetup) {
        CreateTimer(0.1, ChangeRoundTimeTimer, _, TIMER_FLAG_NO_MAPCHANGE);
    }
}

public Action EventSetupFinished(Handle event, const char[] name, bool dontBroadcast) {
    CreateTimer(0.1, ChangeRoundTimeTimer, _, TIMER_FLAG_NO_MAPCHANGE);
    return Plugin_Continue;
}

public Action ChangeRoundTimeTimer(Handle timer, int data) {
    int roundTimer = FindEntityByClassname(MaxClients + 1, "team_round_timer");
    if(IsValidEntity(roundTimer)) {
        LogMessage("Setting round time to %d seconds", g_cvRoundTime.IntValue);
        SetVariantInt(g_cvRoundTime.IntValue);
        AcceptEntityInput(roundTimer, "SetMaxTime");
        SetVariantInt(g_cvRoundTime.IntValue);
        AcceptEntityInput(roundTimer, "SetTime");
    } else {
        LogMessage("ERROR: Unable to adjust round time, failed to find team_round_timer entity");
    }
}