#pragma semicolon 1
#pragma newdecls required

#include <sourcemod>
#include <sdktools>
#include <tf2>
#include <tf2_stocks>

#define PLUGIN_AUTHOR  "ack"
#define PLUGIN_VERSION "0.01"

public Plugin myinfo = {
	name = "eotl_random_team",
	author = PLUGIN_AUTHOR,
	description = "make auto join actually be random",
	version = PLUGIN_VERSION,
	url = ""
};

ConVar g_cvEnabled;

public void OnPluginStart() {
    LogMessage("version %s starting", PLUGIN_VERSION);
    g_cvEnabled = CreateConVar("eotl_random_team_enabled", "1", "enable/disable plugin", FCVAR_NOTIFY, true, 0.0, true, 1.0);
    AddCommandListener(CommandJoinTeam, "jointeam");
}

public Action CommandJoinTeam(int client, const char[] command, int args)
{

    if(!g_cvEnabled.BoolValue || args != 1) {
        return Plugin_Continue;
    }

    char arg[64];
    GetCmdArg(1, arg, sizeof(arg));

    if(strcmp(arg, "auto") != 0) {
        return Plugin_Continue;
    }

    int redCount = 0;
    int blueCount = 0;

    for(int i = 1; i <= MaxClients; i++) {
        if(!IsClientInGame(i)) {
            continue;
        }

        TFTeam team = TF2_GetClientTeam(i);
        if(team == TFTeam_Blue) {
            blueCount++;
        } else if(team == TFTeam_Red) {
            redCount++;
        }
    }

    if(redCount == blueCount) {
        TFTeam picked;
        if(GetRandomInt(0, 1)) {
            picked = TFTeam_Blue;
        } else {
            picked = TFTeam_Red;
        }

        LogMessage("client: %d teams same size, picked %s as random team", client, (picked == TFTeam_Blue ? "Blue" : "Red"));
        PrintToChatAll("\x01[\x03eotl\x01] randomly assigning %N to %s", client, (picked == TFTeam_Blue ? "BLU" : "RED"));

        TF2_ChangeClientTeam(client, picked);
        ShowVGUIPanel(client, (picked == TFTeam_Blue ? "class_blue" : "class_red"));

        return Plugin_Stop;
    }

    return Plugin_Continue;
}