#pragma semicolon 1
#pragma newdecls required

#include <sourcemod>
#include <sdkhooks>
#include <sdktools_trace>
#include <sdktools_functions>
#include <tf2_stocks>

#define PLUGIN_AUTHOR  "ack"
#define PLUGIN_VERSION "0.1"

#define CONFIG_FILE     "configs/eotl_ttb.cfg"

public Plugin myinfo = {
	name = "eotl_ttb",
	author = PLUGIN_AUTHOR,
	description = "Ten Ton Brick Sound Bites",
	version = PLUGIN_VERSION,
	url = ""
};

StringMap g_smSoundBites;
StringMap g_smDescriptions;
ArrayList g_alShortNames;
int g_iPlayerPlays[MAXPLAYERS + 1];
float g_fLastPlay;
ConVar g_cvMaxPlayerPlays;
ConVar g_cvMinTime;

public void OnPluginStart() {
    LogMessage("version %s starting", PLUGIN_VERSION);
    RegConsoleCmd("sm_ttb", CommandTTB);

    g_cvMaxPlayerPlays = CreateConVar("eotl_ttb_max_player_plays", "2", "maximum number of times a player can play a ttb per map");
    g_cvMinTime  = CreateConVar("eotl_ttb_min_time", "10.0", "number of seconds that must pass before another ttb can be played");

    g_alShortNames = CreateArray(16);
}

public void OnMapStart() {
    g_smSoundBites = CreateTrie();
    g_smDescriptions = CreateTrie();
    g_alShortNames.Clear();

    g_fLastPlay = 0.0;
    for(int client = 1; client <= MaxClients; client++) {
        g_iPlayerPlays[client] = 0;
    }

    LoadConfig();
}

public void OnMapEnd() {
    CloseHandle(g_smSoundBites);
    CloseHandle(g_smDescriptions);
}

public void OnClientConnected(int client) {
    g_iPlayerPlays[client] = 0;
}

public Action CommandTTB(int client, int args) {
    char shortName[16];
    char soundFile[PLATFORM_MAX_PATH];

    if(args > 1) {
        PrintToChat(client, "\x01[\x03ttb\x01] Invalid syntax");
        return Plugin_Handled;
    }

    if(args == 0) {
        // pick random shortname
        // doing this in one lines seems to be less random?
        int rand = GetURandomInt();
        int index = rand % g_alShortNames.Length;
        g_alShortNames.GetString(index, shortName, sizeof(shortName));

        
    } else {
        GetCmdArg(1, shortName, sizeof(shortName));
        StringToLower(shortName);
    }

    if(StrEqual(shortName, "list")) {
        SendSoundBiteList(client);
        return Plugin_Handled;
    }

    if(!g_smSoundBites.GetString(shortName, soundFile, sizeof(soundFile))) {
        PrintToChat(client, "\x01[\x03ttb\x01] error invalid soundbite %s, use \"!ttb list\" for a list", shortName);
        return Plugin_Handled;
    }

    // see if the user is allowed to play a ttb
    if(g_iPlayerPlays[client] >= g_cvMaxPlayerPlays.IntValue) {
        PrintToChat(client,"\x01[\x03ttb\x01] sorry you are limited to %d ttb's per map", g_cvMaxPlayerPlays.IntValue);
        return Plugin_Handled;
    }

    float timeDiff = GetGameTime() - g_fLastPlay;
    if(timeDiff < g_cvMinTime.FloatValue) {
        PrintToChat(client, "\x01[\x03ttb\x01] You must wait %.1f seconds before another ttb will be allowed", g_cvMinTime.FloatValue - timeDiff);
        return Plugin_Handled;
    }

    g_iPlayerPlays[client]++;
    g_fLastPlay = GetGameTime();

    char description[32];
    g_smDescriptions.GetString(shortName, description, sizeof(description));
    PrintToChat(client, "\x01[\x03ttb\x01] Playing %s - %s", shortName, description);
    LogMessage("Playing shortname: %s, file: %s, description: %s", shortName, soundFile, description);
    EmitSoundToAll(soundFile);
    return Plugin_Handled;
}

void SendSoundBiteList(int client) {
    char shortName[16];
    char description[32];

    PrintToChat(client, "\x03Ten Ton Brick Sound Bites\x01:");
    PrintToChat(client, "\x03  !ttb\x01    - random sound bite");
    for(int i = 0; i < g_alShortNames.Length;i++) {
        g_alShortNames.GetString(i, shortName, sizeof(shortName));
        g_smDescriptions.GetString(shortName, description, sizeof(description));
        PrintToChat(client, "\x03  !ttb %s\x01 - %s", shortName, description);
    }
}

void LoadConfig() {
    KeyValues cfg = CreateKeyValues("ttb");

    char configFile[PLATFORM_MAX_PATH];
    BuildPath(Path_SM, configFile, sizeof(configFile), CONFIG_FILE);

    LogMessage("loading config file: %s", configFile);
    if(!FileToKeyValues(cfg, configFile)) {
        SetFailState("unable to load config file!");
        return;
    }

    char shortName[16];
    char description[32];
    char soundFile[PLATFORM_MAX_PATH];
    char downloadFile[PLATFORM_MAX_PATH];
    if(cfg.JumpToKey("soundBites")) {
        KvGotoFirstSubKey(cfg);
        do {

            cfg.GetSectionName(shortName, sizeof(shortName));
            cfg.GetString("description", description, sizeof(description));
            cfg.GetString("soundBite", soundFile, sizeof(soundFile));
            g_smSoundBites.SetString(shortName, soundFile);
            g_smDescriptions.SetString(shortName, description);
            g_alShortNames.PushString(shortName);

            Format(downloadFile, sizeof(downloadFile), "sound/%s", soundFile);
            AddFileToDownloadsTable(downloadFile);
            PrecacheSound(soundFile, true);
            LogMessage("loaded %s = %s with description %s", shortName, soundFile, description);
        } while(KvGotoNextKey(cfg));
    }
    CloseHandle(cfg);  
}

void StringToLower(char[] string) {
    int len = strlen(string);
    int i;

    for(i = 0;i < len;i++) {
        string[i] = CharToLower(string[i]);
    }
}