#pragma semicolon 1
#pragma newdecls required

#include <sourcemod>
#include "eotl_vip.inc"

#define PLUGIN_AUTHOR  "ack"
#define PLUGIN_VERSION "0.01"

#define DB_CONFIG      "default"
#define DB_TABLE       "vip_users"
#define DB_COL_ICONID  "iconID"
#define DB_COL_STEAMID "steamID"

public Plugin myinfo = {
	name = "eotl_vip",
	author = PLUGIN_AUTHOR,
	description = "eotl vip plugin that contains common function calls",
	version = PLUGIN_VERSION,
	url = ""
};

enum struct PlayerState {
	bool isVip;
}

GlobalForward g_OnPostClientVipCheckForward;
PlayerState g_playerStates[MAXPLAYERS + 1];
Handle g_dbh;

public void OnPluginStart() {
	LogMessage("version %s starting", PLUGIN_VERSION);
	g_OnPostClientVipCheckForward = CreateGlobalForward("OnPostClientVipCheck", ET_Event, Param_Cell, Param_Cell);
}

public void OnMapStart() {
	for (int client = 1; client <= MaxClients; client++) {
        g_playerStates[client].isVip = false;
    }

	if(!ConnectDB()) {
        LogError("will re-attempt database connection when a client connects");
    }
}

public void OnClientConnected(int client) {
    char name[64];

    if(GetClientName(client, name, sizeof(name))) {
        //LogMessage("client: %d connect (%s)", client, name);
    } else {
        LogError("client: %d connect (no name!?)", client);
    }
}

public void OnClientDisconnect(int client) {
	g_playerStates[client].isVip = false;
}

public void OnClientAuthorized(int client, const char[] auth) {

	if(IsFakeClient(client)) {
		return;
	}

	g_playerStates[client].isVip = LoadVipStatus(client, auth, true);
	//LogMessage("client: %d, (%s) vip: %s", client, auth, (g_playerStates[client].isVip ? "YES" : "NO"));

	Call_StartForward(g_OnPostClientVipCheckForward);
	Call_PushCell(client);
	Call_PushCell(g_playerStates[client].isVip);
	Call_Finish();
}

bool LoadVipStatus(int client, const char[] steamid, bool retryDB) {

	if(g_dbh == INVALID_HANDLE) {
		LogError("LoadVipStatus() not connected to database, attempting reconnect");
		if(!ConnectDB()) {
			LogError("client: %d LoadVipStatus() still no connection to database, forcing non-vip for them", client);
			return false;
		}
		return LoadVipStatus(client, steamid, false);
	}

	char query[128];
	DBResultSet results;

	Format(query, sizeof(query), "SELECT %s from %s where %s = '%s'", DB_COL_ICONID, DB_TABLE, DB_COL_STEAMID, steamid);
	results = SQL_Query(g_dbh, query);

	// this seems to be an indication we aren't connected to the database anymore
	if(results == INVALID_HANDLE) {
		CloseHandle(g_dbh);
		g_dbh = INVALID_HANDLE;
		if(retryDB) {
			return LoadVipStatus(client, steamid, false);
		}
		LogError("client: %d LoadVipStatus() SQL_Query returned INVALID_HANDLE. Something maybe wrong with the connection to the database, forcing non-vip for them", client);
		return false;
	}

	bool rval = false;
	if(results.RowCount > 0) {
		rval = true;
	}

	CloseHandle(results);
	return rval;
}

bool ConnectDB() {

    if(!SQL_CheckConfig(DB_CONFIG)) {
        SetFailState("Database config \"%s\" doesn't exist", DB_CONFIG);
    }

    char error[256];
    g_dbh = SQL_Connect(DB_CONFIG, false, error, sizeof(error));
    if(g_dbh == INVALID_HANDLE) {
        LogError("connection to database failed (DB config: %s): %s", DB_CONFIG, error);
        return false;
    }

    //LogMessage("connected to database");
    return true;
}

public APLRes AskPluginLoad2(Handle myself, bool late, char[] error, int err_max) {
	RegPluginLibrary("eotl_vip");
	CreateNative("IsClientVip", Native_IsClientVip);
	return APLRes_Success;
}

public int Native_IsClientVip(Handle hPlugin, int numParams) {
	int client = GetNativeCell(1);

	if(client < 1 || client > MaxClients) {
		LogError("IsClientVip() called with invalid client number: %d", client);
		return false;
	}
	return g_playerStates[client].isVip;
}