#pragma semicolon 1
#pragma newdecls required

#include <sourcemod>
#include <tf2>
#include <tf2_stocks>
#include "eotl_vip.inc"

#define PLUGIN_AUTHOR  "ack"
#define PLUGIN_VERSION "0.01"

public Plugin myinfo = {
	name = "eotl_vip.teamswap",
	author = PLUGIN_AUTHOR,
	description = "eotl vip team swap plugin, allow forced team swaps for vips",
	version = PLUGIN_VERSION,
	url = ""
};

enum struct PlayerState {
	bool isVip;
    int lastSwap;
}

PlayerState g_playerStates[MAXPLAYERS + 1];
bool g_roundOver;
ConVar g_cvEnabled;
ConVar g_cvVipOnly;
ConVar g_cvMinTime;

public void OnPluginStart() {
    LogMessage("version %s starting", PLUGIN_VERSION);

    g_cvEnabled = CreateConVar("eotl_vip_teamswap_enabled", "1", "Enable or disable the plugin 1=On, 0=Off", FCVAR_NOTIFY, true, 0.0, true, 1.0);
    g_cvVipOnly = CreateConVar("eotl_vip_teamswap_viponly", "1", "Restrict team swaps 1=Vips 0=All", FCVAR_NOTIFY, true, 0.0, true, 1.0);
    g_cvMinTime = CreateConVar("eotl_vip_teamswap_mintime", "120", "Number of seconds player must wait between team swaps", FCVAR_NOTIFY, true, 0.0, false);

    RegConsoleCmd("sm_teamswap", CommandTeamSwap);
}

public void OnMapStart() {
    g_roundOver = false;

    for (int client = 1; client <= MaxClients; client++) {
        g_playerStates[client].isVip = false;
        g_playerStates[client].lastSwap = 0;
	}

    HookEvent("teamplay_round_start", EventRoundStart, EventHookMode_PostNoCopy);
    
    HookEvent("teamplay_round_stalemate", EventRoundEnd, EventHookMode_PostNoCopy);
    HookEvent("teamplay_round_win", EventRoundEnd, EventHookMode_PostNoCopy);
    HookEvent("teamplay_game_over", EventRoundEnd, EventHookMode_PostNoCopy);
}

public void OnClientDisconnect(int client) {
    g_playerStates[client].isVip = false;
    g_playerStates[client].lastSwap = 0;
}

public void OnPostClientVipCheck(int client, bool isVip) {

    if(IsFakeClient(client)) {
        return;
    }

    if(IsClientConnected(client)) {
        g_playerStates[client].isVip = isVip;
    }
}

public Action EventRoundStart(Handle event, const char[] name, bool dontBroadcast) {
    g_roundOver = false;
}

public Action EventRoundEnd(Handle event, const char[] name, bool dontBroadcast) {
    g_roundOver = true;
}

public Action CommandTeamSwap(int client, int args) {

    if(IsFakeClient(client)) {
        return Plugin_Handled;
    }

    if(!GetConVarBool(g_cvEnabled)) {
        PrintToChat(client, "teamswap plugin is disabled");
        return Plugin_Handled;
    }

    if(GetConVarBool(g_cvVipOnly) && !g_playerStates[client].isVip) {
        PrintToChat(client, "teamswap requires vip status and you aren't a vip");
        return Plugin_Handled;
    }

    TFTeam team = TF2_GetClientTeam(client);
    if(team != TFTeam_Blue && team != TFTeam_Red) {
        PrintToChat(client, "can't swap teams when you aren't on a team");
        return Plugin_Handled;
    }

    if(g_roundOver) {
        PrintToChat(client, "team swap not allowed during end of round");
        return Plugin_Handled;
    }

    int swapAge = GetTime() - g_playerStates[client].lastSwap;
    int minAge = GetConVarInt(g_cvMinTime);

    if(swapAge < minAge) {
        PrintToChat(client, "team swaps are only allowed every %d seconds, you last swapped %d seconds ago", minAge, swapAge);
        return Plugin_Handled;
    }

    g_playerStates[client].lastSwap = GetTime();

    if(!ChangeClientTeam(client, view_as<int>(team == TFTeam_Blue ? TFTeam_Red : TFTeam_Blue))) {
        LogError("failed to switch client %d to other team");
        return Plugin_Handled;
    }
    TF2_RespawnPlayer(client);

    LogMessage("client: %d !teamswap'd to %s", client, (team == TFTeam_Blue ? "RED" : "BLUE"));
    return Plugin_Handled;
}
