public PlVers:__version =
{
	version = 3,
	filevers = "1.0.4",
	date = "06/10/2014",
	time = "07:01:51"
};
new Float:NULL_VECTOR[3];
new String:NULL_STRING[4];
new Handle:s_svVisiblemaxplayers;
new Handle:s_smHreservedSlotsEnable;
new Handle:s_smHreservedSlotsAmount;
new Handle:s_smHreservedAdminProtection;
new Handle:s_smHreservedImmunityDecrement;
new Handle:s_smHreservedUseImmunity;
new Handle:s_smHreservedDropMethod;
new Handle:s_smHreservedDropSelect;
new Handle:s_smHreservedRedirectTarget;
new Handle:s_smHreservedRedirectTimer;
new Handle:s_smHreservedBotProtection;
new Handle:s_smAuthByTag;
new Handle:s_smAuthTag;
new s_priorityVector[65];
public Extension:__ext_Connect =
{
	name = "Connect",
	file = "connect.ext",
	autoload = 1,
	required = 0,
};
public Plugin:myinfo =
{
	name = "HANSE Reserved Slots",
	description = "Provides mani admin-style slots reservation",
	author = "red!",
	version = "2.0",
	url = "http://www.hanse-clan.de"
};
bool:operator>=(Float:,Float:)(Float:oper1, Float:oper2)
{
	return FloatCompare(oper1, oper2) >= 0;
}

bool:operator<(Float:,Float:)(Float:oper1, Float:oper2)
{
	return FloatCompare(oper1, oper2) < 0;
}

DisplayAskConnectBox(client, Float:time, String:ip[])
{
	new Handle:Kv = CreateKeyValues(64, 72, 76);
	KvSetFloat(Kv, 80, time);
	KvSetString(Kv, 88, ip);
	CreateDialog(client, Kv, 4);
	CloseHandle(Kv);
	return 0;
}

public OnPluginStart()
{
	LoadTranslations("hreservedslots.phrases");
	CreateConVar("hreserved_slots", "2.0", "Version of [HANSE] Reserved Slots", 262464, 0, 0, 0, 0);
	RegConsoleCmd("hrs_status", 15, 664, 0);
	s_svVisiblemaxplayers = FindConVar("sv_visiblemaxplayers");
	s_smHreservedSlotsEnable = CreateConVar("sm_hreserved_slots_enable", "1", "disable/enable reserved slots", 0, 0, 0, 0, 0);
	HookConVarChange(s_smHreservedSlotsEnable, 5);
	s_smHreservedSlotsAmount = CreateConVar("sm_hreserved_slots_amount", "-1", "number of reserved slots (do not specify or set to -1 to automatically use hidden slots as reserved)", 0, 0, 0, 0, 0);
	s_smHreservedAdminProtection = CreateConVar("sm_hreserved_admin_protection", "1", "protect admins from beeing dropped from server by reserved slot access (0: no protection, 1: except spec mode, 2: full protection)", 0, 0, 0, 0, 0);
	s_smHreservedUseImmunity = CreateConVar("sm_hreserved_use_immunity", "1", "use sourcemod immunity level to find a player to be dropped (0: do not use immunity , 1: use immunity level)", 0, 0, 0, 0, 0);
	s_smHreservedImmunityDecrement = CreateConVar("sm_hreserved_immunity_decrement", "1", "value to be subtracted from the immunity level of spectators. The value 0 will make spectators to be treated like players in the game", 0, 0, 0, 0, 0);
	s_smHreservedRedirectTarget = CreateConVar("sm_hreserved_redirect_target", 1408, "alternate server a client is offered to be redirected to, if sm_hreserved_drop_method is set to value 2", 0, 0, 0, 0, 0);
	s_smHreservedRedirectTimer = CreateConVar("sm_hreserved_redirect_timer", "12", "time to show the redirection offer dialog", 0, 0, 0, 0, 0);
	s_smHreservedDropMethod = CreateConVar("sm_hreserved_drop_method", "1", "method for dropping players to free a reserved slot (0: no players are dropped from server, 1: kick, 2: offer to be redirected to the server specified in sm_hreserved_redirect_target)", 0, 0, 0, 0, 0);
	s_smHreservedDropSelect = CreateConVar("sm_hreserved_drop_select", "0", "select how players are chosen to be dropped from server when there are multiple targets with the same priority. (0: highest ping, 1: shortest connection time, 2: random)", 0, 0, 0, 0, 0);
	s_smHreservedBotProtection = CreateConVar("sm_hreserved_bot_protection", "0", "kick bots/fake clients (e.g. SourceTV)? (0: kick, 1:  do not kick)", 0, 0, 0, 0, 0);
	AutoExecConfig(1, "hreserved_slots", "sourcemod");
	s_smAuthByTag = CreateConVar("sm_hreserved_auth_by_tag", "0", "authenticate admins by clan tag specified by sm_hreserved_auth_tag; 0: off, 1:on", 0, 0, 0, 0, 0);
	s_smAuthTag = CreateConVar("sm_hreserved_auth_tag", 2280, "authentication clan tag", 0, 0, 0, 0, 0);
	new String:errBuf[40];
	new connStatus = GetExtensionFileStatus("connect.ext", errBuf, 40);
	if (connStatus == 1)
	{
		LogMessage("'connect' extension avaiable");
	}
	else
	{
		if (connStatus != -2)
		{
			LogMessage("'connect' extension present but inoperable due to '%s' (code %d)", errBuf, connStatus);
		}
	}
	return 0;
}

public bool:OnClientPreConnect(String:name[], String:password[256], String:ip[], String:steamID[], String:rejectReason[256])
{
	if (isPublicSlot(true))
	{
		return true;
	}
	if (0 < getReservedSlots())
	{
		return true;
	}
	new AdminId:admin = FindAdminByIdentity("steam", steamID);
	if (admin != AdminId:-1)
	{
		if (hasReservedSlotAccess(name, GetAdminFlags(admin, 1)))
		{
			refreshPriorityVector();
			DropPlayerByWeight(true);
		}
	}
	return true;
}

public OnClientPostAdminCheck(clientSlot)
{
	if (isPublicSlot(false))
	{
		return 0;
	}
	new String:playername[52];
	GetClientName(clientSlot, playername, 49);
	if (hasReservedSlotAccess(playername, GetUserFlagBits(clientSlot)))
	{
		if (GetConVarInt(s_smHreservedDropMethod))
		{
			refreshPriorityVector();
			DropPlayerByWeight(false);
		}
	}
	else
	{
		if (GetConVarInt(s_smHreservedDropMethod) == 2)
		{
			CreateTimer(1084227584, 13, GetClientUserId(clientSlot), 0);
		}
		CreateTimer(1036831949, 9, GetClientUserId(clientSlot), 0);
	}
	return 0;
}

bool:hasReservedSlotAccess(String:playername[], userFlags)
{
	if (GetConVarBool(s_smAuthByTag))
	{
		new String:authTag[52];
		GetConVarString(s_smAuthTag, authTag, 50);
		if (0 <= StrContains(playername, authTag, 1))
		{
			return true;
		}
	}
	new var1;
	if (userFlags & 16384 || userFlags & 1)
	{
		return true;
	}
	return false;
}

bool:isPublicSlot(bool:isPreconnect)
{
	if (GetConVarInt(s_smHreservedSlotsEnable))
	{
		decl currentClientCount;
		new var1;
		if (isPreconnect)
		{
			var1 = 1;
		}
		else
		{
			var1 = 0;
		}
		currentClientCount = var1 + GetClientCount(1);
		new publicSlots = getPublicSlots();
		return currentClientCount <= publicSlots;
	}
	return true;
}

public OnPluginEnabled(Handle:convar, String:oldValue[], String:newValue[])
{
	if (0 < GetConVarInt(s_smHreservedSlotsEnable))
	{
		if (GetConVarInt(s_smHreservedDropMethod))
		{
			refreshPriorityVector();
			new i = getPublicSlots();
			while (GetClientCount(1) > i)
			{
				DropPlayerByWeight(false);
				i++;
			}
		}
	}
	return 0;
}

getVisibleSlots()
{
	new visibleSlots;
	new var1;
	if (s_svVisiblemaxplayers && GetConVarInt(s_svVisiblemaxplayers) == -1)
	{
		visibleSlots = GetMaxClients();
	}
	else
	{
		visibleSlots = GetConVarInt(s_svVisiblemaxplayers);
	}
	return visibleSlots;
}

getPublicSlots()
{
	return GetMaxClients() - getReservedSlots();
}

getReservedSlots()
{
	new reservedSlots = GetConVarInt(s_smHreservedSlotsAmount);
	if (reservedSlots == -1)
	{
		reservedSlots = GetMaxClients() - getVisibleSlots();
	}
	return reservedSlots;
}

bool:DropPlayerByWeight(bool:enforce)
{
	new String:playername[52];
	new lowestImmunity = getLowestImmunity();
	if (lowestImmunity > -100)
	{
		LogMessage("selecting player of lowest immunity group (%d)", lowestImmunity);
		new target = findDropTarget(lowestImmunity);
		if (target > -1)
		{
			s_priorityVector[target] = -100;
			GetClientName(target, playername, 49);
			new var1;
			if (enforce)
			{
				var1 = 2508;
			}
			else
			{
				var1 = 2564;
			}
			LogMessage("[hreserved_slots] dropping %s%s", playername, var1);
			if (enforce)
			{
				KickToFreeSlotNow(target);
			}
			else
			{
				new var2;
				if (GetConVarInt(s_smHreservedDropMethod) == 2 && !IsFakeClient(target))
				{
					CreateTimer(1036831949, 13, GetClientUserId(target), 0);
				}
				CreateTimer(1036831949, 11, GetClientUserId(target), 0);
			}
			return true;
		}
	}
	else
	{
		LogMessage("no non-admins available to drop, giving up.");
	}
	LogMessage("[hreserved_slots] no matching client found to kick");
	return false;
}

getLowestImmunity()
{
	new lowestImmunity = -200;
	new i = GetMaxClients();
	while (0 < i)
	{
		if (s_priorityVector[i] > -100)
		{
			if (lowestImmunity == -200)
			{
				lowestImmunity = s_priorityVector[i];
			}
			if (s_priorityVector[i] < lowestImmunity)
			{
				lowestImmunity = s_priorityVector[i];
			}
		}
		i--;
	}
	return lowestImmunity;
}

refreshPriorityVector()
{
	new immunity;
	new AdminId:aid;
	new bool:hasReserved;
	new i = GetMaxClients();
	while (0 < i)
	{
		if (IsClientInGame(i))
		{
			aid = GetUserAdmin(i);
			if (aid == AdminId:-1)
			{
				immunity = 0;
				hasReserved = false;
			}
			else
			{
				immunity = GetAdminImmunityLevel(aid);
				hasReserved = GetAdminFlag(aid, 0, 1);
			}
			if (!(GetConVarInt(s_smHreservedUseImmunity)))
			{
				immunity = 0;
			}
			new var1;
			if (GetClientTeam(i) && GetClientTeam(i) == 1)
			{
				immunity -= GetConVarInt(s_smHreservedImmunityDecrement);
			}
			if (hasReserved)
			{
				switch (GetConVarInt(s_smHreservedAdminProtection))
				{
					case 1:
					{
						if (GetClientTeam(i) != 1)
						{
							immunity = -100;
						}
					}
					case 2:
					{
						immunity = -100;
					}
					default:
					{
					}
				}
			}
			new var2;
			if (GetConVarInt(s_smHreservedBotProtection) > 0 && IsFakeClient(i))
			{
				immunity = -100;
			}
		}
		else
		{
			immunity = -100;
		}
		s_priorityVector[i] = immunity;
		i--;
	}
	return 0;
}

printPriorityVector(clientSlot)
{
	new String:playername[52];
	new String:immunity[16];
	new i = GetMaxClients();
	while (0 < i)
	{
		if (IsClientInGame(i))
		{
			GetClientName(i, playername, 49);
		}
		else
		{
			playername = "not connected";
		}
		if (s_priorityVector[i] <= -100)
		{
			immunity = "unkickable";
		}
		else
		{
			Format(immunity, 15, "%d", s_priorityVector[i]);
		}
		PrintToConsole(clientSlot, "[hreserved_slots] id: %d, name: %s, immunity: %s", i, playername, immunity);
		i--;
	}
	new lowest_immunity = getLowestImmunity();
	PrintToConsole(clientSlot, "[hreserved_slots] maximum slots: %d", GetMaxClients());
	PrintToConsole(clientSlot, "[hreserved_slots] visible slots: %d", getVisibleSlots());
	PrintToConsole(clientSlot, "[hreserved_slots] public slots: %d", getPublicSlots());
	new reservedSlots = getReservedSlots();
	new var1;
	if (reservedSlots)
	{
		if (GetConVarInt(s_smHreservedSlotsAmount) == -1)
		{
			var1 = 2924;
		}
		var1 = 2944;
	}
	else
	{
		var1 = 2900;
	}
	PrintToConsole(clientSlot, "[hreserved_slots] reserved slots: %d (%s)", reservedSlots, var1);
	PrintToConsole(clientSlot, "[hreserved_slots] minimum_immunity: %d", lowest_immunity);
	PrintToConsole(clientSlot, "[hreserved_slots] highest ping target: %d", findHighestPing(lowest_immunity));
	PrintToConsole(clientSlot, "[hreserved_slots] shortest connect target: %d", findShortestConnect(lowest_immunity));
	PrintToConsole(clientSlot, "[hres erved_slots] random target: %d", findRandomTarget(lowest_immunity));
	PrintToConsole(clientSlot, "[hreserved_slots] pre 1.0.8 target: %d", selectAnyPlayer(lowest_immunity));
	PrintToConsole(clientSlot, "[hreserved_slots] selected target: %d", findDropTarget(lowest_immunity));
	return 0;
}

public Action:debugPrint(clientSlot, args)
{
	if (0 < clientSlot)
	{
		new AdminId:aid = GetUserAdmin(clientSlot);
		new var1;
		if (aid == AdminId:-1 || !GetAdminFlag(aid, 1, 1))
		{
			PrintToConsole(clientSlot, "[hreserved_slots] you do not have the rights to access this command");
			return Action:3;
		}
	}
	refreshPriorityVector();
	printPriorityVector(clientSlot);
	return Action:3;
}

findDropTarget(lowestImmunity)
{
	new targetSlot;
	switch (GetConVarInt(s_smHreservedDropSelect))
	{
		case 0:
		{
			targetSlot = findHighestPing(lowestImmunity);
		}
		case 1:
		{
			targetSlot = findShortestConnect(lowestImmunity);
		}
		case 2:
		{
			targetSlot = findRandomTarget(lowestImmunity);
		}
		default:
		{
			targetSlot = findHighestPing(lowestImmunity);
		}
	}
	if (targetSlot == -1)
	{
		targetSlot = selectAnyPlayer(lowestImmunity);
	}
	return targetSlot;
}

findRandomTarget(immunity_group)
{
	new targetCount;
	new target = -1;
	new i = GetMaxClients();
	while (0 < i)
	{
		new var1;
		if (immunity_group == s_priorityVector[i] && !IsFakeClient(i))
		{
			targetCount++;
		}
		i--;
	}
	if (0 < targetCount)
	{
		new targetInGroup = GetRandomInt(1, targetCount);
		new j = GetMaxClients();
		while (0 < j)
		{
			new var2;
			if (immunity_group == s_priorityVector[j] && !IsFakeClient(j))
			{
				targetInGroup--;
				if (!targetInGroup)
				{
					target = j;
				}
			}
			j--;
		}
	}
	if (target != -1)
	{
		LogMessage("selected random target %d", target);
	}
	return target;
}

findHighestPing(immunity_group)
{
	new Float:hping = -1.0;
	new target = -1;
	new i = GetMaxClients();
	while (0 < i)
	{
		new var1;
		if (immunity_group == s_priorityVector[i] && !IsFakeClient(i) && GetClientAvgLatency(i, 2) >= hping)
		{
			hping = GetClientAvgLatency(i, 2);
			target = i;
		}
		i--;
	}
	if (target != -1)
	{
		LogMessage("selected highest ping target %d", target);
	}
	return target;
}

findShortestConnect(immunity_group)
{
	new Float:ctime = -1.0;
	new target = -1;
	new i = GetMaxClients();
	while (0 < i)
	{
		new var1;
		if (immunity_group == s_priorityVector[i] && !IsFakeClient(i))
		{
			new var2;
			if (ctime < 0.0 || GetClientTime(i) < ctime)
			{
				ctime = GetClientTime(i);
				target = i;
			}
		}
		i--;
	}
	if (target != -1)
	{
		LogMessage("selected shortest connected target %d", target);
	}
	return target;
}

selectAnyPlayer(immunity_group)
{
	new i = GetMaxClients();
	while (0 < i)
	{
		if (immunity_group == s_priorityVector[i])
		{
			LogMessage("emergency selection of target %d", i);
			return i;
		}
		i--;
	}
	return -1;
}

public Action:OnTimedKickForReject(Handle:timer, any:value)
{
	new clientSlot = GetClientOfUserId(value);
	new var1;
	if (!clientSlot || !IsClientInGame(clientSlot))
	{
		return Action:3;
	}
	new String:playername[52];
	GetClientName(clientSlot, playername, 49);
	new String:playerid[52];
	GetClientAuthString(clientSlot, playerid, 49);
	LogMessage("kicking rejected player %s [%s]", playername, playerid);
	KickClient(clientSlot, "%T", "no free slots", clientSlot);
	return Action:3;
}

public Action:OnTimedKickToFreeSlot(Handle:timer, any:value)
{
	new clientSlot = GetClientOfUserId(value);
	KickToFreeSlotNow(clientSlot);
	return Action:3;
}

KickToFreeSlotNow(clientSlot)
{
	new var1;
	if (!clientSlot || !IsClientInGame(clientSlot))
	{
		return 0;
	}
	new String:playername[52];
	GetClientName(clientSlot, playername, 49);
	new String:playerid[52];
	GetClientAuthString(clientSlot, playerid, 49);
	LogMessage("kicking player %s [%s] to free slot", playername, playerid);
	KickClient(clientSlot, "%T", "kicked for free slot", clientSlot);
	return 0;
}

public Action:OnTimedRedirect(Handle:timer, any:value)
{
	new client = GetClientOfUserId(value);
	new var1;
	if (!client || !IsClientInGame(client))
	{
		return Action:3;
	}
	new String:target[128];
	GetConVarString(s_smHreservedRedirectTarget, target, s_smHreservedRedirectTarget);
	new Float:displayTime = GetConVarFloat(s_smHreservedRedirectTimer);
	new String:playername[52];
	GetClientName(client, playername, 49);
	new String:playerid[52];
	GetClientAuthString(client, playerid, 49);
	LogMessage("offering redirection to player %s [%s]", playername, playerid);
	CreateTimer(displayTime, 11, value, 0);
	DisplayAskConnectBox(client, displayTime, target);
	PrintCenterText(client, "%T", "server offers to reconnect", client);
	return Action:3;
}

 

